program tile

integer, parameter :: n = 1331, reps=1
real(kind=8) :: a(n,n), b(n,n), c(n,n)
real(kind=8) :: time1,second
 
do j = 1,n 
   do i = 1,n
      a(i,j)=7.0*i
      b(i,j)=6.0/i
      c(i,j)=23.0/j
   end do
end do 

time1=second()
do i=1,reps 
   call matmul(a,b,c,n)
   if (c(n,n) .eq. -999) exit
end do 
time1=second()-time1

print *, "sum(c) = ", sum(c)
print *,"Time =      ",time1
print *,"Mflops = ",real(2*n*n)*real(n*reps)/(1000000.*time1)

end

